﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using Inet.Viewer.WinForms.Prompt;
using Inet.Viewer.Data;

namespace Inet.Viewer.test.WinForms
{
    
    /// <summary>
    /// Tests the boolean prompt panel
    /// </summary>
    [TestFixture]
    public class TestSingleBooleanPromptField
    {
        /// <summary>
        /// Simple first test
        /// </summary>
        [Test]
        public void TestBooleanPanel()
        {
            PromptData p1 = new PromptData(
                "prompt", null, "desc", new string[] { }, new string[] { }, PromptData.Boolean, true, false, false, true, false,
                false, null, null, null);
            SingleBooleanPromptField f = new SingleBooleanPromptField(p1);
            Assert.AreEqual(2, f.cmbValueBox.Items.Count);
        }

        /// <summary>
        /// Tests whether the chosen value is re-entered
        /// </summary>
        [Test]
        public void TestBooleanPanelLoadsUpChosenValue()
        {
            PromptData p1 = new PromptData(
                "prompt", null, "desc", new string[] { }, new string[] { }, PromptData.Boolean, true, false, false, true, false,
                false, null, null, null);
            p1.Values = new SinglePromptValue(false, null, PromptData.Boolean);
            SingleBooleanPromptField f = new SingleBooleanPromptField(p1);
            Assert.AreEqual(2, f.cmbValueBox.Items.Count);
            Assert.AreEqual(1, f.cmbValueBox.SelectedIndex);
        }
    }
}
